
/*  */
/*     HAMEG GmbH                                                          */
/*     Sample programm for Interface HO79                                  */
/*     Data transfer from HAMEG Digital/Analog Oscilloscopes               */
/*     Command : "DIG"                                                     */
/*  */

#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <mc.h>
#include <param.h>
#include <ho79data.h>

/*  */
int main (int, char * []);
/*  */

struct param_set	dig_param_set = {
	"DIG - Demo program fr HO79 + HO80 (IEEE tranfer )",   "DIG dev=b",
	{ {"dev", "device"},
	  {"seg", "segment"},
	  {"", ""}, {"", ""}, {"", ""}, {"", ""},
	  {"", ""}, {"", ""}, {"", ""}, {"", ""}  }
};
/*  */
/*                                m a i n                                  */
/*  */

int main (argc, argv)
int		argc;
char	*argv[];
{
int 	ieee_chef, my_address;
int     status, anz, pos;

	seg = 0xc000;
	if ( (param (argc, argv, &dig_param_set) !=0) || (argc<=1))
		return(1);
	HO80_SEG = seg;
	if (ieee_se(HO80_SEG) != 0) {
		printf ("HO80 IEEE-488 not found");
		return (2);
	}
	ieee_chef = 0;									/*  IEEE - Controller	*/
	my_address = 21;			
	init (&ieee_chef,&my_address);
	delay (3000);				
	iwd (&status, "FRM 0", &dev);			/* set binary format */ 
	iwd (&status, "DIG", &dev);
	anz=ho79_data(dev);
	printf (" \n %d empfangene Bytes", anz);
	bioskey (0);
	for (pos=0; pos <anz; pos++) {
		if (pos%0x10==0) printf ("\n %4X   ", pos);
		printf (" %2X", data[pos]);
	}
	return(0);
}
